using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
	public static partial class PATIENT_IMAGEManager
	{
		#region Fields
		#endregion

		#region Properties
		#endregion

		#region Methods

		public static PATIENT_IMAGE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_IMAGE_ID)
		{
			PATIENT_IMAGE objReturn = null;
			PATIENT_IMAGEDB objDB = new PATIENT_IMAGEDB();

			objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_IMAGE_ID);

			return objReturn;
		}

		public static List<PATIENT_IMAGE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<PATIENT_IMAGE> objReturn = null;
			PATIENT_IMAGEDB objDB = new PATIENT_IMAGEDB();

			objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

			return objReturn;
		}

		public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, PATIENT_IMAGE objSave)
		{
			Int32 objReturn = 0;
			PATIENT_IMAGEDB objDB = new PATIENT_IMAGEDB();

			objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

			return objReturn;
		}

        public static void Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int patientId, IEnumerable<STAGING_PATIENT_IMAGE> images)
        {
            PATIENT_IMAGEDB objDB = new PATIENT_IMAGEDB();

            if (images != null && images.Any(i => i.PATIENT_ID != patientId))
                throw new Exception("Images collection contains one or more elements that does not match provided patient ID.");

            objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, patientId, images);
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_IMAGE_ID)
		{
			Boolean objReturn = false;
			PATIENT_IMAGEDB objDB = new PATIENT_IMAGEDB();

			objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_IMAGE_ID);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, PATIENT_IMAGE objDelete)
		{
			return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.PATIENT_IMAGE_ID);
		}

        public static IEnumerable<STAGING_PATIENT_IMAGE> GetStagingPatientImagesFromStudies(
            string currentUser, 
            int patientId, 
            IEnumerable<Study> studies)
        {
            if (studies == null || !studies.Any())
                return null;

            var now = DateTime.Now;

            return studies.Select(study => new STAGING_PATIENT_IMAGE
            {
                STUDY_ID = study.StudyId,
                PATIENT_ID = patientId,
                IMAGE_COUNT = study.ImageCount,
                IS_SENSITIVE = study.IsSensitive,
                STUDY_CLASS = study.StudyClass,
                STUDY_TYPE = study.StudyType,
                STUDY_DESCRIPTION = study.StudyDescription,
                PROCEDURE_DESCRIPTION = study.ProcedureDescription,
                SPECIALTY_DESCRIPTION = study.SpecialtyDescription,
                REPORT_URL = study.ReportUrl,
                VIEWER_URL = study.ViewerUrl,
                STUDY_DATE = study.StudyDate != null ? DateTime.Parse(study.StudyDate) : (DateTime?)null,
                CREATED = now,
                CREATEDBY = currentUser
            }).ToList();
        }

        public static DateTime? GetSourceRefreshDate(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID)
        {
            var db = new PATIENT_IMAGEDB();

            return db.GetSourceRefreshDate(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
        }

        #endregion
    }
}
